import pandas as pd  
from sklearn.preprocessing import LabelEncoder 
import pickle 
from decision_company import read_csv_file, col_assign_val, create_label_encoder, fit_transform_label_encoder, get_dummies
  
# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Preprocess the data by applying Label Encoding to 'savings_status' and 'employment'  
col_assign_val(data_for_clustering, 'savings_status', fit_transform_label_encoder(create_label_encoder(), data_for_clustering['savings_status']) ) 
col_assign_val(data_for_clustering, 'employment', fit_transform_label_encoder(create_label_encoder(), data_for_clustering['employment'])) 

# Apply One-Hot Encoding to 'credit_history'  
data_for_clustering = get_dummies(data_for_clustering, columns=['credit_history'], drop_first=True)  

print("data_for_clustering:\n", data_for_clustering)    
pickle.dump(data_for_clustering,open("./ref_result/data_for_clustering.pkl","wb"))